#ifndef SOUNDPLAYER_H
#define SOUNDPLAYER_H

#include <QObject>
#include <phonon/MediaObject>
#include <phonon/VideoWidget>
#include <phonon/AudioOutput>
#include <phonon/VolumeSlider>

class SoundPlayer : public QWidget
{
	Q_OBJECT

public:
	SoundPlayer(QWidget *container);
	~SoundPlayer();

    QString source() const { return m_source; }
	bool isPlaying() const { return m_isPlaying; }
	bool isLooping() const { return m_isLooping; }
	qreal volume() const { return m_audioOutput->volume(); }

	void setSource(const QString &source);
	void setVolume(qreal newVolume) { m_audioOutput->setVolume(newVolume); }

	void stop();
	void play();
	void playLooping();

signals:
	void volumeChanged(qreal newVolume);

private slots:
	void finished();
	void mutedChanged(bool muted);

private:
	Phonon::MediaObject *m_mediaObject;
	Phonon::AudioOutput *m_audioOutput;
	Phonon::VolumeSlider *m_volumeSlider;
	QString m_source;
	bool m_isLooping;
	bool m_isPlaying;
};

#endif // SOUNDPLAYER_H
