#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <phonon/audiooutput.h>
#include <phonon/volumeslider.h>
#include <phonon/mediaobject.h>

class CollectorDiagramWidget;
class CollectorStatisticWidget;
class KeypadWidget;
class SerialPort;
class SoundPlayer;

QT_BEGIN_NAMESPACE
class QTabWidget;
class QHBoxLayout;
class QPushButton;
class QTextEdit;
class QRadioButton;
class QSettings;
class QElapsedTimer;
class QLabel;
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
	~MainWindow();

protected:
	void closeEvent(QCloseEvent *event);

private slots:
	void tick();
	void delayRadioButton_Click();
	void snoozeRadioButton_Click();
	void alarmRadioButton_Click();
	void collectorCountRadioButton_Click();
	void rowCountRadioButton_Click();
	void portNameRadioButton_Click();
	void portTimeoutRadioButton_Click();
    void setTimeoutDelay(int);
    void setAlarmDelay(int);
    void setSnoozeDuration(int);
	void setCollectorCount(int);
	void setRowCount(int);
    void setPortName(int);
    void snooze();
	void diagramClicked();
	void laneClicked(int);
	void tabChanged(int);
    void addressClicked();
	void volumeChanged(qreal);
	void addressChanged();

private:
	void createDiagramTab(QTabWidget *optionsTabWidget);
	void createStatisticsTab(QTabWidget *optionsTabWidget);
	void createConfigurationTab(QTabWidget *optionsTabWidget);
	void createLogTab(QTabWidget *optionsTabWidget);
	void log(QString message);
    void loadSettings();
	void saveSettings();
    void loadStyleSheet(const QString &styleSheetFileName /*= ":/style/style.qss"*/);
    QString readSerial();
	bool playAlarm();

	KeypadWidget *mKeypadWidget;
	QList<CollectorDiagramWidget*> *mDiagramList;
	QList<CollectorStatisticWidget*> *mStatisticList;
	QHBoxLayout *mStatisticBoxLayout;
    QHBoxLayout *mDiagramBoxLayout;
    QPushButton *mSnoozeButton;
	QTextEdit *mLogTextArea;
	SerialPort *mSerialPort;
	QSettings *mSettings;
	QTimer *mProcessTimer;
	QLabel *mEggCountLabel;
	SoundPlayer *mSoundPlayer;
	QElapsedTimer *mSnoozeTimer;

	int mTimeout;
	int mAlarmDelay;
	int mSnoozeDuration;
	int mAlarmVolume;
	int mRowCount;
	int mCollectorCount;
	long mEggCount;
};

#endif // MAINWINDOW_H
