#ifndef LARGEDIALOG_H
#define LARGEDIALOG_H

#include <QDialog.h>

QT_BEGIN_NAMESPACE
class QString;
class QWidget;
class QLabel;
class QPushButton;
class QHBoxLayout;
QT_END_NAMESPACE

class LargeDialog : public QDialog
{
	Q_OBJECT
	Q_ENUMS(Button)
public:
	// Summary:
	//     Specifies constants defining which buttons to display on a LargeDialog.
	enum Button
	{
		OK		= 0,
		Cancel	= 1,
		Abort	= 2,
		Retry	= 4,
		Ignore	= 8,
		No		= 32,
		Yes		= 16
	};
	Q_DECLARE_FLAGS(Buttons, Button)

	// Summary:
	//     Specifies constants defining which information to display.
	enum Icon
	{
		// Summary:
		//     The message box contain no symbols.
		None = 0,
		//
		// Summary:
		//     The message box contains a symbol consisting of white X in a circle with
		//     a red background.
		Error = 16,
		//
		// Summary:
		//     The message box contains a symbol consisting of a white X in a circle with
		//     a red background.
		Hand = 16,
		//
		// Summary:
		//     The message box contains a symbol consisting of white X in a circle with
		//     a red background.
		Stop = 16,
		//
		// Summary:
		//     The message box contains a symbol consisting of a question mark in a circle.
		//     The question-mark message icon is no longer recommended because it does not
		//     clearly represent a specific type of message and because the phrasing of
		//     a message as a question could apply to any message type. In addition, users
		//     can confuse the message symbol question mark with Help information. Therefore,
		//     do not use this question mark message symbol in your message boxes. The system
		//     continues to support its inclusion only for backward compatibility.
		Question = 32,
		//
		// Summary:
		//     The message box contains a symbol consisting of an exclamation point in a
		//     triangle with a yellow background.
		Exclamation = 48,
		//
		// Summary:
		//     The message box contains a symbol consisting of an exclamation point in a
		//     triangle with a yellow background.
		Warning = 48,
		//
		// Summary:
		//     The message box contains a symbol consisting of a lowercase letter i in a
		//     circle.
		Information = 64,
		//
		// Summary:
		//     The message box contains a symbol consisting of a lowercase letter i in a
		//     circle.
        Asterisk = 64
	};

public:
    LargeDialog(const QString &text = "", const QString &caption = "", int buttons = LargeDialog::Yes | LargeDialog::No, Icon icon = Question, const QRect &geometry = QRect(0, 330, 795, 240), QWidget *parent = 0, Qt::WindowFlags f = 0);
    LargeDialog(const QRect &geometry);
	~LargeDialog();
	void setText(const QString &text);
	void setButtons(int buttons);
	void setIcon(Icon icon);
	void setFont(const QFont &font);

private:
	void init();

	static const int DIALOG_BUTTON_COUNT = 3;
	QLabel *messageLabel;
	QLabel *iconLabel;
	QPushButton* dialogButtons[DIALOG_BUTTON_COUNT];

private slots:
	void buttonClicked();
};
Q_DECLARE_OPERATORS_FOR_FLAGS(LargeDialog::Buttons)

#endif // LARGEDIALOG_H
