#include "LargeDialog.h"

#include "SquareLayout.h"

#include <QString.h>
#include <QLabel.h>
#include <QBoxLayout.h>
#include <QPushButton.h>
#include <QList.h>
#include <QMetaObject.h>
#include <QMessageBox.h>
#include <QDebug.h>

#include <exception>

LargeDialog::LargeDialog(const QString &text /*= ""*/, const QString &caption /*= ""*/, int buttons /*= Button::Yes | Button::No*/, Icon icon /*= Question*/, const QRect &geometry /*= QRect(0, 330, 795, 240)*/, QWidget *parent /*= 0*/, Qt::WindowFlags f /*= 0*/)
	: QDialog(parent, f)
{
	messageLabel = new QLabel();
	iconLabel = new QLabel();
	
	QWidget *iconContainer = new QWidget();
	SquareLayout *iconLayout = new SquareLayout();
	QFrame *buttonContainer = new QFrame();
	QWidget *messageContainer = new QWidget();
	QHBoxLayout *messageLayout = new QHBoxLayout();
	QVBoxLayout *mainLayout = new QVBoxLayout();
	QHBoxLayout *buttonsLayout = new QHBoxLayout();

	iconLayout->addWidget(iconLabel);
	messageLayout->addWidget(iconContainer);
	messageLayout->addWidget(messageLabel);
	mainLayout->addWidget(messageContainer);
	mainLayout->addWidget(buttonContainer);

	iconContainer->setLayout(iconLayout);
	buttonContainer->setLayout(buttonsLayout);
	messageContainer->setLayout(messageLayout);

	messageLayout->setStretchFactor(iconContainer, 20);
	messageLayout->setStretchFactor(messageLabel, 80);
	mainLayout->setStretchFactor(messageContainer, 7);
	mainLayout->setStretchFactor(buttonContainer, 3);

    messageContainer->setStyleSheet("background-color: white;");

	mainLayout->setMargin(0);
	mainLayout->setSpacing(0);

	for(int i = 0; i < DIALOG_BUTTON_COUNT; i++)
	{
		QPushButton *button = new QPushButton();
		button->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
		connect(button, SIGNAL(clicked()), this, SLOT(buttonClicked()));
		dialogButtons[i] = button;
		buttonsLayout->addWidget(dialogButtons[i]);
	}

    //this.Text = caption;
	setGeometry(geometry);
	setLayout(mainLayout);
	setText(text);

	QMetaEnum meta = LargeDialog::staticMetaObject.enumerator(0);
	int buttonIndex = DIALOG_BUTTON_COUNT;
	for (int i = 0; i < meta.keyCount() && buttonIndex >= 0; i++)
	{
		if (buttons & meta.value(i))
		{
			dialogButtons[--buttonIndex]->setText(meta.key(i));
		}
	}
	while(buttonIndex >= 0)
	{
		dialogButtons[--buttonIndex]->setEnabled(false);
	}

	setIcon(icon);
	setWindowTitle(caption);
}

LargeDialog::~LargeDialog()
{
	delete messageLabel;
	delete iconLabel;
	for(int i = 0; i < DIALOG_BUTTON_COUNT; i++)
		delete dialogButtons[i];
}

void LargeDialog::init()
{

}

LargeDialog::LargeDialog(const QRect &geometry)
{
	setGeometry(geometry);
}

void LargeDialog::buttonClicked()
{
	QPushButton *button = qobject_cast<QPushButton*>(sender());
	Q_ASSERT(button);
	setResult(LargeDialog::staticMetaObject.enumerator(0).keyToValue(button->text().toStdString().c_str()));
	close();
}

void LargeDialog::setText( const QString &text )
{
	messageLabel->setText(text);
}

void LargeDialog::setButtons(int buttons)
{
	QMetaEnum meta = LargeDialog::staticMetaObject.enumerator(0);
	int buttonIndex = DIALOG_BUTTON_COUNT;
	for (int i = 0; i < meta.keyCount() && buttonIndex >= 0; i++)
	{
		if (buttons & meta.value(i))
		{
			dialogButtons[buttonIndex]->setText(meta.key(i));
			dialogButtons[buttonIndex]->setEnabled(true);
			buttonIndex--;
		}
	}
	while(buttonIndex >= 0)
		dialogButtons[buttonIndex--]->setEnabled(false);
}

void LargeDialog::setIcon( Icon icon )
{
	switch (icon)
	{
    case Information: //case MessageBoxIcon.Asterisk:
        iconLabel->setStyleSheet("border-image: url(:/images/information.png) stretch stretch;");
		break;
    case Exclamation: //case MessageBoxIcon.Warning:
        iconLabel->setStyleSheet("border-image: url(:/images/exclamation.png) stretch stretch;");
		break;
    case Question:
        iconLabel->setStyleSheet("border-image: url(:/images/question.png) stretch stretch;");
        break;
    case Error: //case MessageBoxIcon.Stop: //case MessageBoxIcon.Hand:
        iconLabel->setStyleSheet("border-image: url(:/images/error.png) stretch stretch;");
		break;
    case None:
		iconLabel->setStyleSheet("border-image: none;");
		break;
	default:
        qDebug() << "The value of argument 'icon' (" << icon << ") is invalid for Enum type 'MessageBoxIcon'.";
	}
}
