#ifndef KEYPADWIDGET_H
#define KEYPADWIDGET_H

#include <QWidget.h>
#include <QSet.h>

QT_BEGIN_NAMESPACE
class QPushButton;
class QLabel;
QT_END_NAMESPACE

class KeypadWidget :
	public QWidget
{
	Q_OBJECT
	Q_ENUMS(ModeType)

public:
	KeypadWidget(QWidget *parent = 0);
	~KeypadWidget() {}

	enum ModeType { Range, Selection };

	void setValue(int);
	void setDefaultValue(int);
	void setMinimum(int);
	void setMaximum(int);
	void setSelections(QSet<int>);
	void setMode(ModeType);

	int value() const { return m_value; }
	int defaultValue() const { return m_defaultValue; }
	int minimum() const { return m_minimum; }
	int maximum() const { return m_maximum; }
	QSet<int> selections() const { return m_selections; }
	ModeType mode() const { return m_mode; }

public slots:
	void reset();

signals:
	void valueChanged(int);

private slots:
	void digitClicked();
	void backClicked();

protected:
	virtual void keyPressEvent ( QKeyEvent * event );

private:
	int m_value;
	int m_defaultValue;
	int m_minimum;
	int m_maximum;
	ModeType m_mode;
	QSet<int> m_selections;
	QPushButton *m_digitButtons[10];
	QPushButton *m_deleteButton;
	QPushButton *m_resetButton;
	QLabel *m_valueLabel;
};

#endif // KEYPADWIDGET_H