#ifndef COLLECTORSTATISTICWIDGET_H
#define COLLECTORSTATISTICWIDGET_H

#include <QFrame.h>

QT_BEGIN_NAMESPACE
class QLabel;
class QGridLayout;
class QElapsedTimer;
QT_END_NAMESPACE

class ClickableLabel;

class CollectorStatisticWidget :
	public QFrame
{
	Q_OBJECT

public:
	CollectorStatisticWidget(int address = 0, int rowCount = 0, QWidget *parent = 0);
	~CollectorStatisticWidget();

	int rowCount() const { return m_rowCount; }
	int address() const { return m_address; }
	int total() const { return m_total; }
	int laneValue(int index) const { return m_laneValues[index]; }

public slots:
	void setAddress(int address);
	void setRowCount(int);
	void setLaneValue(int index, int value);

signals:
	void addressChanged();
    void addressClicked();

private slots:
    void labelClicked();

private:
    int *m_laneValues;
	QVector<QLabel*> m_laneLabels;
	QGridLayout *m_gridLayout;
	QLabel *m_totalLabel;
    ClickableLabel *m_addressLabel;
	long m_total;
	int m_rowCount;
	int m_address;
};

#endif // COLLECTORSTATISTICWIDGET_H
