#include "CollectorStatisticWidget.h"

#include <QLabel>
#include <QGridLayout>
#include <QElapsedTimer>

#include "ClickableLabel.h"

static QLabel* createExpandingLabel(QString text = "0")
{
    QLabel *result = new QLabel(text);
    result->setStyleSheet("border: 1px solid gainsboro; border-radius: 0px;");
	result->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    result->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    return result;
}

CollectorStatisticWidget::CollectorStatisticWidget(int address /*= 0*/, int rowCount /*= 0*/, QWidget *parent /*= 0*/)
	: QFrame(parent)
	, m_laneValues(0)
	, m_gridLayout(0)
	, m_total(0)
	, m_rowCount(0)
{
	m_gridLayout = new QGridLayout();
	m_totalLabel = createExpandingLabel();
	m_addressLabel = new ClickableLabel(QString::number(address));

	QVBoxLayout *mainLayout = new QVBoxLayout();
	QWidget *gridWidget = new QWidget();

    mainLayout->setSpacing(0);
    mainLayout->setMargin(0);
    m_gridLayout->setSpacing(0);
    m_gridLayout->setMargin(0);
	gridWidget->setLayout(m_gridLayout);
	mainLayout->addWidget(m_addressLabel);
	mainLayout->addWidget(gridWidget);
	mainLayout->addWidget(m_totalLabel);
	setLayout(mainLayout);

	setAddress(address);
	setRowCount(rowCount);

    m_addressLabel->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    m_addressLabel->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    connect(m_addressLabel, SIGNAL(clicked()), this, SLOT(labelClicked()));
}

CollectorStatisticWidget::~CollectorStatisticWidget(void)
{
	delete m_laneValues;
	delete m_gridLayout;
}

void CollectorStatisticWidget::setLaneValue(int index, int count)
{
	QPalette palette;
	m_total += count - m_laneValues[index];
	m_totalLabel->setText(QString::number(m_total));
	m_laneValues[index] = count;
	m_laneLabels[index]->setText(QString::number(count));
}

void CollectorStatisticWidget::setRowCount(int rowCount)
{
	Q_ASSERT(rowCount >= 0);

	if (m_rowCount == rowCount)
		return;

	while(!m_laneLabels.isEmpty())
	{
		QLabel *label = m_laneLabels.first();
		m_gridLayout->removeWidget(label);
		m_laneLabels.remove(0);
		delete label;
	}
	m_laneLabels.resize(rowCount * 2);
	if (rowCount > 0)
	{
		delete[] m_laneValues;
		m_laneValues = new int[rowCount*2];
		for(int i = 0; i < rowCount; i++)
		{
			int leftID = rowCount * 2 - i - 1, rightID = rowCount - i - 1;

			m_laneValues[leftID] = 0;
			m_laneValues[rightID] = 0;		
			m_laneLabels[leftID] = createExpandingLabel();
            m_laneLabels[rightID] = createExpandingLabel();

            m_gridLayout->addWidget(m_laneLabels[leftID], i, 0);
			m_gridLayout->addWidget(m_laneLabels[rightID], i, 1);
		}
	}
	update();

	m_total = 0;
	m_rowCount = rowCount;
}

void CollectorStatisticWidget::labelClicked()
{
    ClickableLabel *label = qobject_cast<ClickableLabel*>(sender());
    Q_ASSERT(label);
    if (label == m_addressLabel)
        emit addressClicked();
}

void CollectorStatisticWidget::setAddress(int address)
{
	m_addressLabel->setText("Address " + QString::number(address));
	m_address = address;
	emit addressChanged();
}
