#ifndef COLLECTORDIAGRAMWIDGET_H
#define COLLECTORDIAGRAMWIDGET_H

#include <QFrame.h>

QT_BEGIN_NAMESPACE
class QPixmap;
class QGridLayout;
class QWidget;
class QLabel;
class QMouseEvent;
class QVBoxLayout;
QT_END_NAMESPACE

class LaneWidgetItem;
class ClickableLabel;

class CollectorDiagramWidget
	: public QFrame
{
    Q_OBJECT
    Q_ENUMS(StateType)

public:
    CollectorDiagramWidget(int rowCount = 0, QWidget *parent = 0);
    ~CollectorDiagramWidget();

	enum StateType
	{
		Unknown,
		Ignored,
		Good,
		Bad
	};

	int rowCount() const { return m_rowCount; }
	StateType state() const { return m_state; }
	StateType laneState(int index) const { return m_laneStates[index]; }

	void setRowCount(int);
	void setState(StateType);
	void setLaneState(int, StateType);

signals:
	void laneClicked(int);
    void collectorClicked();

protected:
    virtual void mousePressEvent(QMouseEvent * event);

private slots:
	void laneClicked();

private:
	StateType *m_laneStates;
	QVector<ClickableLabel*> m_laneLabels;
	QVBoxLayout *m_layout;
	StateType m_state;
	int m_rowCount;
};

#endif // COLLECTORDIAGRAMWIDGET_H
