#include "CollectorDiagramWidget.h"

#include "SquareLayout.h"
#include "ClickableLabel.h"

CollectorDiagramWidget::CollectorDiagramWidget(int rowCount /*= 0*/, QWidget *parent /*= 0*/)
	: QFrame(parent)
	, m_laneStates(0)
	, m_laneLabels(0)
	, m_rowCount(0)
{
	m_layout = new QVBoxLayout();
	m_layout->setSpacing(0);
	m_layout->setMargin(0);
	m_layout->setContentsMargins(0,0,0,0);
	setLayout(m_layout);

    setState(Unknown);
	setRowCount(rowCount);
}

CollectorDiagramWidget::~CollectorDiagramWidget(void)
{
	delete m_laneStates;
}

void CollectorDiagramWidget::setState(StateType state)
{
	switch(state)
	{
    case Bad:
        setStyleSheet("border-image: url(:/images/collector_red.png) stretch stretch;");
		break;
    case Good:
        setStyleSheet("border-image: url(:/images/collector_green.png) stretch stretch;");
		break;
    case Ignored:
        setStyleSheet("border-image: url(:/images/collector_gray.png) stretch stretch;");
		break;
    case Unknown:
        setStyleSheet("border-image: url(:/images/collector_yellow.png) stretch stretch;");
        break;
    }
	m_state = state;
}

QWidget* centerWidget(QWidget *item)
{
	QWidget *result = new QWidget();
	SquareLayout *layout = new SquareLayout();
	layout->addWidget(item);
	result->setLayout(layout);
	layout->setMargin(0);
	layout->setSpacing(0);
	layout->setContentsMargins(0,0,0,0);
	result->setContentsMargins(0,0,0,0);
	return result;
}

void CollectorDiagramWidget::mousePressEvent( QMouseEvent * )
{
    emit collectorClicked();
}

void CollectorDiagramWidget::laneClicked()
{
	ClickableLabel *label = qobject_cast<ClickableLabel*>(sender());
	Q_ASSERT(label);
	int index = m_laneLabels.indexOf(label);
	Q_ASSERT(index >= 0);
	emit laneClicked(index);
}

void CollectorDiagramWidget::setRowCount(int rowCount)
{
	Q_ASSERT(rowCount >= 0);

	if (m_rowCount == rowCount)
		return;

	if (rowCount > 0)
	{
		delete[] m_laneStates;
		m_laneStates = new StateType[rowCount*2];
		while(!m_laneLabels.isEmpty())
		{
			QLabel *label = m_laneLabels.first();
			QWidget *labelContainer = label->parentWidget();
			SquareLayout *containerLayout = qobject_cast<SquareLayout*>(labelContainer->layout());

			delete label;
			delete containerLayout;
			delete labelContainer;
			m_laneLabels.remove(0);
		}
		QLayoutItem *child;
		while ((child = m_layout->takeAt(0)) != 0) {
			delete child;
		}
		m_laneLabels.resize(rowCount * 2);
        for(int i = 0; i < rowCount; i++)
		{
			int leftID = rowCount * 2 - i - 1, rightID = rowCount - i - 1;
            m_laneStates[leftID] = Unknown;
            m_laneStates[rightID] = Unknown;
			
			QFrame *frame = new QFrame();
			QHBoxLayout *horizontalLayout = new QHBoxLayout();
			ClickableLabel *leftLabel = new ClickableLabel();
			ClickableLabel *rightLabel = new ClickableLabel();

			m_laneLabels[leftID] = leftLabel;
			m_laneLabels[rightID] = rightLabel;

			connect(leftLabel, SIGNAL(clicked()), this, SLOT(laneClicked()));
			connect(rightLabel, SIGNAL(clicked()), this, SLOT(laneClicked()));

			frame->setContentsMargins(0,0,0,0);
			frame->setStyleSheet("border-image: none;");

            leftLabel->setStyleSheet("border-image: url(:/images/lane_yellow.png) stretch stretch;");
			leftLabel->setMargin(0);

            rightLabel->setStyleSheet("border-image: url(:/images/lane_yellow.png) stretch stretch;");
			rightLabel->setMargin(0);

			horizontalLayout->setMargin(0);
			horizontalLayout->setSpacing(0);
			horizontalLayout->setContentsMargins(0,0,0,0);

			QLabel *leftSpacer = new QLabel();
			QLabel *centerSpacer = new QLabel();
			QLabel *rightSpacer = new QLabel();
			QWidget *leftLane = centerWidget(leftLabel);
			QWidget *rightLane = centerWidget(rightLabel);

			if (i != rowCount - 1)
			{
				horizontalLayout->addWidget(leftSpacer);
                horizontalLayout->setStretchFactor(leftSpacer, 20 * (rowCount - i - 1) * (1.0 / (rowCount - 1)));
			}
			horizontalLayout->addWidget(leftLane);
			horizontalLayout->setStretchFactor(leftLane, 30);
            if (i != 0)
            {
                horizontalLayout->addWidget(centerSpacer);
                horizontalLayout->setStretchFactor(centerSpacer, 30 * i * (1.0 / (rowCount - 1)));
            }
            horizontalLayout->addWidget(rightLane);
			horizontalLayout->setStretchFactor(rightLane, 30);
			if (i != rowCount - 1)
			{
				horizontalLayout->addWidget(rightSpacer);
                horizontalLayout->setStretchFactor(rightSpacer, 20 * (rowCount - i - 1) * (1.0 / (rowCount - 1)));
			}
			frame->setLayout(horizontalLayout);
			m_layout->addWidget(frame);
		}
	}
	update();

	m_rowCount = rowCount;
}

void CollectorDiagramWidget::setLaneState(int index, StateType state)
{
	QLabel *item = m_laneLabels[index];
	Q_ASSERT(item);
	switch(state)
	{
    case Bad:
        item->setStyleSheet("border-image: url(:/images/lane_red.png) stretch stretch;");
		break;
    case Good:
        item->setStyleSheet("border-image: url(:/images/lane_green.png) stretch stretch;");
		break;
    case Ignored:
        item->setStyleSheet("border-image: url(:/images/lane_gray.png) stretch stretch;");
		break;
    case Unknown:
        item->setStyleSheet("border-image: url(:/images/lane_yellow.png) stretch stretch;");
		break;
	}
	m_laneStates[index] = state;
}
