PROJECT                 = EARL

TARGET                  = EARL

DESTDIR                 = bin

CONFIG                 += qt warn_on release

OBJECTS_DIR             = obj

MOC_DIR                 = obj

DEPENDDIR               = .

INCLUDEDIR              = .

QT                     += phonon

RESOURCES               = resources/images.qrc resources/sounds.qrc resources/style.qrc

HEADERS                 = src/ClickableLabel.h \
                          src/CollectorDiagramWidget.h \
                          src/CollectorStatisticWidget.h \
                          src/LargeDialog.h \
                          src/KeypadWidget.h \
                          src/MainWindow.h \
                          src/SerialEnumerator.h \
                          src/SerialPort.h \
                          src/SoundPlayer.h \
                          src/SquareLayout.h \

SOURCES                 = src/ClickableLabel.cpp \
                          src/CollectorDiagramWidget.cpp \
                          src/CollectorStatisticWidget.cpp \
                          src/LargeDialog.cpp \
                          src/KeypadWidget.cpp \
                          src/main.cpp \
                          src/MainWindow.cpp \
                          src/SerialPort.cpp \
                          src/SoundPlayer.cpp \
                          src/SquareLayout.cpp

############################################
#       Platform Specific Items Below      #
############################################

unix:SOURCES           += src/SerialPort_posix.cpp

unix:!macx:SOURCES     += src/SerialEnumerator_unix.cpp

macx {
  ICON                  = app.icns
  CONFIG               -= app_bundle
  SOURCES              += src/SerialEnumerator_osx.cpp
  LIBS                 += -framework IOKit -framework CoreFoundation
}

win32 {
  ICON                  = app.ico
  SOURCES              += src/SerialPort_win.cpp src/SerialEnumerator_win.cpp
  DEFINES              += WINVER=0x0501 # needed for mingw to pull in appropriate dbt business...probably a better way to do this
  LIBS                 += -lsetupapi -ladvapi32 -luser32
}

wince*{
  DEPLOYMENT_PLUGIN += phonon_ds9 phonon_waveout
}

symbian:TARGET.UID3 = 0xA000CF6A
